﻿var taskHistory = {
    context: $("#taskHistory"),
    datatable: null,
    referenceTaskId: null,
    refreshDataTable: function () {
        taskHistory.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-taskHistoryTable").a4datatable({
            ajaxAction: a4.getProjectAction("GetTaskHistory", "Tasks", { taskId: taskHistory.referenceTaskId }),
            columns: [
                { "Name": "Title", "Title": resources.TaskTitle, "Data": "Title" },
                { "Name": "UserName", "Title": resources.UserName, "Data": "UserName" },
                { "Name": "CreatedOn", "Title": resources.CreatedOn, "Data": "CreatedOn" },
                { "Name": "TerminatedOn", "Title": resources.TerminatedOn, "Data": "TerminatedOn" },
                { "Name": "Status", "Title": resources.Status, "Data": "StatusLabel", "type": "enum" },
                { "Name": "Result", "Title": resources.Message, "Data": "Result" },
            ],
            defaultSorting: { Column: "TerminatedOn", Ascending: false },
            stateKey: "TaskHistory",
            height: "full"
        });
    }
}

$(document).ready(function () {
    if (taskHistory.context.length > 0) {
        taskHistory.referenceTaskId = $("#ReferenceTaskId", taskHistory.context).val();
        taskHistory.initializeDataTable();
    }
});